#version 330
#extension GL_EXT_gpu_shader4 : enable
// based on BigWIngs Art of CodeMod01.fsh  by  aethelwhat

//https://www.shadertoy.com/view/3sKXRy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define pi 3.14159

float lineSegment(vec2 uv, vec2 coords){
   float dist = length(uv - vec2(clamp(uv.x, coords.x, coords.y), 0));
   return smoothstep(0.3, 0., dist);
}

vec2 getNormal(float angle){
	return vec2(sin(angle), cos(angle));
}

// distance to a rotated line
float distanceToAngle(vec2 pt, vec2 normal){
    return dot(pt, normal);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from -1 to 1)
    //vec2 uv = (gl_FragCoord.xy/iResolution.xy - .5) * 2.;
    // aspect ratio pixel coordinates centered at 0,0 with y range -1 to 1
    vec2 uv = (gl_FragCoord.xy - .5 * iResolution.xy)/iResolution.y;
    uv *= 1.25;
    vec2 mouse = iMouse.xy/iResolution.xy + 0.5; // +.5 to get the Thumbnail image when mouse isn't set
    vec3 col = vec3(0.);
    uv.x = abs(uv.x);
    uv.y -= 0.3; // don't mind me
    //float angle = mouse.x * 3.14159; 
    float angle = 5./6. * pi;
    vec2 norm = getNormal(angle);
    float dist = distanceToAngle(uv - vec2(0.5,0.), norm);
    uv -= norm * 2. * max(dist, 0.);
    
    angle = 2./3. * pi * mouse.x;
    norm = getNormal(angle);
	uv.x += 0.5;
    float scale = 1.0;
    for(int i = 0; i < 4; ++i){
        /* folding iteration */
        scale *= 3.;
        uv *= 3.;
    	uv.x -= 1.5;
        uv.x = abs(uv.x);
        uv.x -= .5;
        uv -= norm * 2. * min(distanceToAngle(uv, norm), 0.);
    }
	
    getNormal(2./3.*pi);
    

    uv/= scale;
    col += texture(iChannel0, uv* cos(iTime * 0.7)).rgb;
     
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}